#include <GUIConstantsEx.au3>
#include <GUIListView.au3>
#include 'TCPInet.au3'

Global $iGUI_WIDTH = 500
Global $iGUI_HEIGHT = 300

Global $ahTCPInet[1][2] = [[0]]
Global $sPath = @DesktopDir

$hGUI = GUICreate('TCPInet.au3 Example', $iGUI_WIDTH, $iGUI_HEIGHT)

$iListView = GUICtrlCreateListView('URL|Progress', 20, 20, $iGUI_WIDTH - 40, $iGUI_HEIGHT - 100, $LVS_SHOWSELALWAYS)
_GUICtrlListView_SetExtendedListViewStyle($iListView, $LVS_EX_DOUBLEBUFFER, $LVS_EX_DOUBLEBUFFER)

$iPauseResume_Bttn = GUICtrlCreateButton('Pause / Resume selected', 20, $iGUI_HEIGHT - 70, 140, 20)
$iStop_Bttn = GUICtrlCreateButton('Stop selected', 180, $iGUI_HEIGHT - 70, 120, 20)
$iDownload_Bttn = GUICtrlCreateButton('Download', 20, $iGUI_HEIGHT - 30, 70, 20)
$iLoadFromCB_Bttn = GUICtrlCreateButton('Load URLs from clipboard', $iGUI_WIDTH - 170, $iGUI_HEIGHT - 70, 150, 20)

GUISetState(@SW_SHOW, $hGUI)
_Load_URLs()

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			If _TCPInet_GetInfo() = 0 Then
				Exit
			EndIf
			
			If MsgBox(52, 'Attention', 'Are you sure, stop all downloads?', 0, $hGUI) = 6 Then
				$aOpenHandles = _TCPInet_GetOpenHandles()
				
				For $i = 1 To $aOpenHandles[0]
					_TCPInet_Close($aOpenHandles[$i])
				Next
				
				Exit
			EndIf
		Case $iLoadFromCB_Bttn
			_Load_URLs()
		Case $iPauseResume_Bttn
			$aSel_Indices = _Check_Sel_Proc()
			
			If @error Or _TCPInet_GetInfo() = 0 Then
				ContinueLoop
			EndIf
			
			For $i = 1 To $aSel_Indices[0]
				For $j = 1 To $ahTCPInet[0][0]
					If $ahTCPInet[$j][0] = $aSel_Indices[$i] Then
						$bCompleted = _TCPInet_GetInfo($ahTCPInet[$j][1], $TCPINET_DOWNLOADCOMPLETE)
						
						If Not @error And Not $bCompleted Then
							$bPause = Not _TCPInet_GetInfo($ahTCPInet[$j][1], $TCPINET_DOWNLOADPAUSED)
							
							_TCPInet_Pause($ahTCPInet[$j][1], $bPause)
							
							$sStatus = ''
							If $bPause Then $sStatus = 'Paused'
							
							_GUICtrlListView_SetItemText($iListView, $aSel_Indices[$i], $sStatus, 1)
						EndIf
						
						ExitLoop
					EndIf
				Next
			Next
		Case $iStop_Bttn
			$aSel_Indices = _Check_Sel_Proc()
			
			If @error Or _TCPInet_GetInfo() = 0 Then
				ContinueLoop
			EndIf
			
			For $i = 1 To $aSel_Indices[0]
				$sStatus = _GUICtrlListView_GetItemText($iListView, $aSel_Indices[$i], 1)
				
				If $sStatus <> '' And $sStatus <> 'Downloaded' Then
					_GUICtrlListView_SetItemText($iListView, $aSel_Indices[$i], 'Stopped', 1)
				EndIf
				
				For $j = 1 To $ahTCPInet[0][0]
					If $ahTCPInet[$j][0] = $aSel_Indices[$i] Then
						_TCPInet_Close($ahTCPInet[$j][1])
						
						If _TCPInet_GetInfo() = 0 Then
							GUICtrlSetState($iDownload_Bttn, $GUI_ENABLE)
							GUICtrlSetState($iLoadFromCB_Bttn, $GUI_ENABLE)
							ExitLoop 2
						EndIf
						
						ExitLoop
					EndIf
				Next
			Next
		Case $iDownload_Bttn
			$aSel_Indices = _Check_Sel_Proc()
			If @error Then ContinueLoop
			
			$sPath = FileSelectFolder('Save to...', '', 1, $sPath, $hGUI)
			If @error Then ContinueLoop
			
			GUICtrlSetState($iDownload_Bttn, $GUI_DISABLE)
			GUICtrlSetState($iLoadFromCB_Bttn, $GUI_DISABLE)
			
			Switch $aSel_Indices[0]
				Case 1 To 10
					_TCPInet_SetMaxBufferLen(16)
				Case 11 To 50
					_TCPInet_SetMaxBufferLen(8)
				Case 51 To 100
					_TCPInet_SetMaxBufferLen(4)
				Case Else ; > 100
					_TCPInet_SetMaxBufferLen(1)
			EndSwitch
			
			For $i = 1 To $aSel_Indices[0]
				$sURL = _GUICtrlListView_GetItemText($iListView, $aSel_Indices[$i], 0)
				
				$ahTCPInet[0][0] += 1
				ReDim $ahTCPInet[$ahTCPInet[0][0] + 1][2]
				
				$ahTCPInet[$ahTCPInet[0][0]][0] = $aSel_Indices[$i]
				$ahTCPInet[$ahTCPInet[0][0]][1] = _TCPInet_GetFile($sURL, $sPath, True, $TCPINET_DOWNLOADBACKGROUND, '_Download_CallBack', $aSel_Indices[$i])
				
				_GUICtrlListView_SetItemText($iListView, $aSel_Indices[$i], _
					'0% (0/' & _TCPInet_GetInfo($ahTCPInet[$ahTCPInet[0][0]][1], $TCPINET_DOWNLOADSIZE) & ')', 1)
			Next
			
			AdlibRegister('_Check_Finish', 1000)
	EndSwitch
WEnd

Func _Load_URLs()
	Local $aURLs = StringRegExp('http://temp' & @CRLF & ClipGet(), '(https?://[^\s"''\]]+)', 3)
	
	If UBound($aURLs) = 0 Then
		MsgBox(64, 'Title', 'Please put some urls to clipboard', 0, $hGUI)
		Return
	EndIf
	
	$aURLs[0] = UBound($aURLs) - 1
	
	_GUICtrlListView_DeleteAllItems($iListView)
	
	For $i = 1 To $aURLs[0]
		GUICtrlCreateListViewItem($aURLs[$i], $iListView)
	Next
	
	_GUICtrlListView_SetColumnWidth($iListView, 0, 300)
	_GUICtrlListView_SetColumnWidth($iListView, 1, 120)
EndFunc

Func _Download_CallBack($hTCPInet, $iSel_Index)
	Local $aInfo = _TCPInet_GetInfo($hTCPInet)
	Local $iError = @error
	
	If $iError Or $aInfo[$TCPINET_DOWNLOADPAUSED] Then
		Return $TCPINET_CB_CONTINUE ;Do nothing (1 to pause, 2 to resume from pause)
	EndIf
	
	If $aInfo[$TCPINET_DOWNLOADCOMPLETE] Or $aInfo[$TCPINET_DOWNLOADSUCCESS] Then
		_GUICtrlListView_SetItemText($iListView, $iSel_Index, 'Downloaded', 1)
		Return $TCPINET_CB_ABORT ;Close the download handle
	EndIf
	
	If Not $aInfo[$TCPINET_DOWNLOADPAUSED] Then
		Local $iProgress = Int(100 / ($aInfo[$TCPINET_DOWNLOADSIZE] / $aInfo[$TCPINET_DOWNLOADREAD]))
		
		If $iProgress < 0 Then
			$iProgress = 0
		EndIf
		
		Local $sProgress = StringFormat('%i% (%i/%i)', $iProgress, $aInfo[$TCPINET_DOWNLOADREAD], $aInfo[$TCPINET_DOWNLOADSIZE])
		_GUICtrlListView_SetItemText($iListView, $iSel_Index, $sProgress, 1)
	EndIf
EndFunc

Func _Check_Finish()
	If _TCPInet_GetInfo() = 0 Then
		AdlibUnRegister('_Check_Finish')
		GUICtrlSetState($iDownload_Bttn, $GUI_ENABLE)
		GUICtrlSetState($iLoadFromCB_Bttn, $GUI_ENABLE)
		MsgBox(64, 'Attention', 'Download completed', 0, $hGUI)
	EndIf
EndFunc

Func _Check_Sel_Proc()
	Local $aSel_Indices = _GUICtrlListView_GetSelectedIndices($iListView, True)
	
	If $aSel_Indices[0] = 0 Then
		MsgBox(48, 'Attention', 'Please select items.', 0, $hGUI)
		Return SetError(1, 0, 0)
	EndIf
	
	Return SetError(0, 0, $aSel_Indices)
EndFunc
